import numpy as np
import torch.linalg as LA

def high_dim_Gaussian(Node_labels, d, mu):
    I = np.identity(d) / d
    X_feature = np.random.multivariate_normal(mu, I, len(Node_labels), 'raise')
    X_feature = X_feature * Node_labels.reshape(-1, 1)
    return X_feature

def high_dim_Laplace(Node_labels, d, mu):
    X_feature = np.random.laplace(loc=mu, scale=1.0, size=(len(Node_labels), d))
    X_feature = X_feature * Node_labels.reshape(-1, 1)
    return X_feature

def angle(vec1, vec2):
    vec_angle = vec1 @ vec2 / (LA.norm(vec1) * LA.norm(vec2))
    return vec_angle